#============================================================================== 
# ** Ruby.Hash
#------------------------------------------------------------------------------
# Description:
# ------------
# Miscellaneous New stuff for the Hash class.
#  
# Method List:
# ------------
# contains_key?
# get_value
#==============================================================================

MACL::Loaded << 'Ruby.Hash'

#============================================================================== 
# ** Hash     
#==============================================================================

class Hash
  #-------------------------------------------------------------------------
  #   Name      : Contains Key?
  #   Info      : Compares all Keys using == similiar to has_key?
  #   Author    : Trickster
  #   Call Info : One, Key an Object
  #-------------------------------------------------------------------------
  def contains_key?(key)
    # Run Through and Return true if keys are equal
    each_key {|other_key| return true if key == other_key}
    # Return false
    return false
  end
  #-------------------------------------------------------------------------
  #   Name      : Get Value
  #   Info      : Gets Value using == similiar to []
  #   Author    : Trickster
  #   Call Info : One, Key an Object
  #-------------------------------------------------------------------------
  def get_value(key)
    # Run Through and Return Key if equal
    each_key {|other_key| return self[other_key] if key == other_key}
    # If Default Proc is undefined return default else call proc
    return default_proc.nil? ? default : default_proc.call(self, key)
  end
end
